<?php

namespace WPML\Records;

use WPML\Core\BackgroundTask;
use WPML\LIB\WP\OnActionMock;

class Test_BackgroundTask extends \OTGS_TestCase {

	use OnActionMock;

	public function setUp() {
		parent::setUp();

		$this->setUpOnAction();
	}

	/**
	 * @test
	 */
	public function it_enqueues() {
		$resourceData    = null;
		$setResourceData = function ( $data ) use ( &$resourceData ) {
			$resourceData = $data;
		};

		$resourcesMock = \Mockery::mock( 'alias:WPML\Core\WP\App\Resources' );
		$resourcesMock->shouldReceive( 'enqueueApp' )->with( 'backgroundTask' )->andReturn( $setResourceData );


		$endpoint     = 'MyEndpoint';
		$endpointData = [ 'some' => 'data' ];
		BackgroundTask::add( $endpoint, $endpointData );

		( new BackgroundTask )->add_hooks();

		$this->runAction( 'wp_loaded' );

		$this->assertEquals( [
			'name' => 'wpml_background_task',
			'data' => [
				'endpoints'     => [ $endpoint ],
				'endpointsData' => [ $endpoint => $endpointData ],
			]
		], $resourceData );
	}
}
