<?php

namespace WPML\LIB\WP;

use WPML\FP\Fns;
use WPML\FP\Just;
use WPML\FP\Logic;
use WPML\FP\Lst;
use WPML\FP\Nothing;
use WPML\FP\Relation;

class Test_Cache extends \OTGS_TestCase {

	use CacheMock;

	public function setUp() {
		parent::setUp();

		$this->setUpCache();
	}

	/**
	 * @test
	 */
	public function it_caches() {

		$group = 'my-group';
		$key = 'my-key';
		$value = 'my-value';

		Cache::set( $group, $key, $value );

		$result = Cache::get( $group, $key );
		$this->assertInstanceOf( Just::class, $result );
		$this->assertEquals( $value, $result->get() );

		$this->assertInstanceOf( Nothing::class, Cache::get( 'wrong group', $key ) );
		$this->assertInstanceOf( Nothing::class, Cache::get( $group, 'wrong key' ) );

	}

	/**
	 * @test
	 */
	public function it_memorizes() {

		$callCount = 0;

		$group = 'my-group';

		$fn = function( $arg1, $arg2 ) use ( &$callCount ) {
			$callCount++;
			return Lst::makePair( $arg1, $arg2 );
		};

		$memorize = Cache::memorize( $group, $fn );
		$this->assertEquals( Lst::makePair( 1, 2 ), $memorize( 1, 2 ) );
		$this->assertEquals( 1, $callCount );

		$this->assertEquals( Lst::makePair( 1, 2 ), $memorize( 1, 2 ) );
		$this->assertEquals( 1, $callCount );

		$this->assertEquals( Lst::makePair( 2, 2 ), $memorize( 2, 2 ) );
		$this->assertEquals( 2, $callCount );

		$this->assertEquals( Lst::makePair( 2, 2 ), $memorize( 2, 2 ) );
		$this->assertEquals( 2, $callCount );

	}

	/**
	 * @test
	 */
	public function it_memorizes_null_values() {

		$callCount = 0;

		$group = 'my-group';

		$fn = function( $arg1, $arg2 ) use ( &$callCount ) {
			$callCount++;
			return null;
		};

		$memorize = Cache::memorize( $group, $fn );
		$this->assertEquals( null, $memorize( 1, 2 ) );
		$this->assertEquals( 1, $callCount );

		$this->assertEquals( null, $memorize( 1, 2 ) );
		$this->assertEquals( 1, $callCount );

		$this->assertEquals( null, $memorize( 2, 2 ) );
		$this->assertEquals( 2, $callCount );

		$this->assertEquals( null, $memorize( 2, 2 ) );
		$this->assertEquals( 2, $callCount );

	}

	/**
	 * @test
	 */
	public function it_memorizes_with_check() {

		$callCount = 0;

		$group = 'my-group';

		$fn = function( $arg1, $arg2 ) use ( &$callCount ) {
			$callCount++;
			return $arg1 + $arg2;
		};

		$checkingFn = Relation::gt( Fns::__, 10 );

		$memorizeWithCheck = Cache::memorizeWithCheck( $group, $checkingFn, $fn );
		$this->assertEquals( 11, $memorizeWithCheck( 9, 2 ) );
		$this->assertEquals( 1, $callCount );

		$this->assertEquals( 11, $memorizeWithCheck( 9, 2 ) );
		$this->assertEquals( 1, $callCount );

		$this->assertEquals( 9, $memorizeWithCheck( 7, 2 ) );
		$this->assertEquals( 2, $callCount );

		$this->assertEquals( 9, $memorizeWithCheck( 7, 2 ) );
		$this->assertEquals( 3, $callCount );

		$this->assertEquals( 9, $memorizeWithCheck( 7, 2 ) );
		$this->assertEquals( 4, $callCount );


	}
}
