<?php

namespace WPML\LIB\WP;

use function WPML\FP\partial;

/**
 * @group option
 */
class TestOption extends \OTGS_TestCase {

	use OptionMock;

	public function setUp() {
		parent::setUp();

		$this->setUpOptionMock();
	}

	/**
	 * @test
	 */
	public function itUpdatesAndGetsAndDeleteOption() {
		$name  = 'my-option';
		$value = 'something';

		$get    = partial( Option::get(), $name );
		$update = Option::update( $name );
		$delete = partial( Option::delete(), $name );

		$this->assertFalse( $get() );

		$this->assertTrue( $update( $value ) );
		$this->assertTrue( $this->options[ $name ]['autoload'] );

		$this->assertEquals( $value, $get() );

		$this->assertTrue( $delete() );

		$this->assertFalse( $get() );
	}

	/**
	 * @test
	 */
	public function itGetsDefaultValueIfOptionDoesNotExist() {
		$name    = 'my-option';
		$default = 'the default value';
		$value   = 'something';

		$getOr  = partial( Option::getOr(), $name );
		$update = Option::update( $name );

		$this->assertEquals( $default, $getOr( $default ) );

		$update( $value );

		$this->assertEquals( $value, $getOr( $default ) );
	}

	/**
	 * @test
	 */
	public function itUpdatesWithoutAutoload() {
		$name  = 'my-option';
		$value = 'something';

		$updateWithoutAutoLoad = Option::updateWithoutAutoLoad( $name );

		$this->assertTrue( $updateWithoutAutoLoad( $value ) );
		$this->assertFalse( $this->options[ $name ]['autoload'] );

		$this->assertEquals( $value, Option::get( $name ) );
	}

	/**
	 * @test
	 */
	public function itUpdatesAndReturnsFalseIfValueWasNotUpdated() {
		$name  = 'my-option';
		$value = 'something';

		$update = Option::update( $name );

		$this->assertTrue( $update( $value ) );
		$this->assertFalse( $update( $value ) );
	}
}
