<?php
if( function_exists('acf_add_local_field_group') ):

	acf_add_local_field_group(array(
		'key' => 'group_5652e8d0993d0',
		'title' => 'Audio Post Options',
		'fields' => array(
			array(
				'key' => 'field_5652e8f042691',
				'label' => 'Audio File',
				'name' => 'audio_file',
				'type' => 'file',
				'instructions' => 'Please upload the audio file here',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'return_format' => 'array',
				'library' => 'all',
				'min_size' => '',
				'max_size' => '',
				'mime_types' => '',
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'post_format',
					'operator' => '==',
					'value' => 'audio',
				),
			),
		),
		'menu_order' => 0,
		'position' => 'normal',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => '',
		'active' => 1,
		'description' => '',
	));

	acf_add_local_field_group(array(
		'key' => 'group_5652e94e97954',
		'title' => 'Gallery Post Options',
		'fields' => array(
			array(
				'key' => 'field_5652e95e72ae3',
				'label' => 'Slider Images',
				'name' => 'slider_images',
				'type' => 'gallery',
				'instructions' => 'Please Upload the images for slider',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'min' => 1,
				'max' => '',
				'preview_size' => 'thumbnail',
				'library' => 'all',
				'min_width' => '',
				'min_height' => '',
				'min_size' => '',
				'max_width' => '',
				'max_height' => '',
				'max_size' => '',
				'mime_types' => '',
				'insert' => 'append',
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'post_format',
					'operator' => '==',
					'value' => 'gallery',
				),
			),
		),
		'menu_order' => 0,
		'position' => 'normal',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => '',
		'active' => 1,
		'description' => '',
	));

	acf_add_local_field_group(array(
		'key' => 'group_564d9eef9ccc9',
		'title' => 'Homepage Fields',
		'fields' => array(
			array(
				'key' => 'field_564dc8a24a97c',
				'label' => 'About Section',
				'name' => '',
				'type' => 'tab',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'placement' => 'top',
				'endpoint' => 0,
			),
			array(
				'key' => 'field_56c46da48b2d3',
				'label' => 'Hide About Section',
				'name' => 'hide_about_section',
				'type' => 'checkbox',
				'instructions' => 'This option will hide the About section',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'choices' => array(
					'Hide' => 'Hide',
				),
				'default_value' => array(
				),
				'layout' => 'vertical',
				'toggle' => 0,
				'allow_custom' => 0,
				'save_custom' => 0,
				'return_format' => 'value',
			),
			array(
				'key' => 'field_5680dec25e21e',
				'label' => 'Menu Id',
				'name' => 'menu_id',
				'type' => 'text',
				'instructions' => 'Please put here the unique id, which will be used for menu',
				'required' => 1,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_56c46da48b2d3',
							'operator' => '!=',
							'value' => 'Hide',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => 'about',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'maxlength' => '',
				'readonly' => 0,
				'disabled' => 0,
			),
			array(
				'key' => 'field_564dc83d4a97b',
				'label' => 'Image',
				'name' => 'image',
				'type' => 'image',
				'instructions' => 'Here you can upload your image.',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_56c46da48b2d3',
							'operator' => '!=',
							'value' => 'Hide',
						),
					),
				),
				'wrapper' => array(
					'width' => '50',
					'class' => '',
					'id' => '',
				),
				'return_format' => 'array',
				'preview_size' => 'thumbnail',
				'library' => 'all',
				'min_width' => '',
				'min_height' => '',
				'min_size' => '',
				'max_width' => '',
				'max_height' => '',
				'max_size' => '',
				'mime_types' => '',
			),
			array(
				'key' => 'field_5a02dcce0b72b',
				'label' => 'Hover Image',
				'name' => 'hover_image',
				'type' => 'image',
				'instructions' => 'Here you can upload your image.',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_56c46da48b2d3',
							'operator' => '!=',
							'value' => 'Hide',
						),
					),
				),
				'wrapper' => array(
					'width' => '50',
					'class' => '',
					'id' => '',
				),
				'return_format' => 'id',
				'preview_size' => 'thumbnail',
				'library' => 'all',
				'min_width' => 50,
				'min_height' => '',
				'min_size' => '',
				'max_width' => '',
				'max_height' => '',
				'max_size' => '',
				'mime_types' => '',
			),
			array(
				'key' => 'field_564dc8d94a97d',
				'label' => 'Status',
				'name' => 'status',
				'type' => 'text',
				'instructions' => 'Say something',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_56c46da48b2d3',
							'operator' => '!=',
							'value' => 'Hide',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => 'Hello',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'maxlength' => '',
				'readonly' => 0,
				'disabled' => 0,
			),
			array(
				'key' => 'field_564dc9024a97e',
				'label' => '1st title field',
				'name' => 'first_title_field',
				'type' => 'text',
				'instructions' => 'Here you can type any text, for example your name',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_56c46da48b2d3',
							'operator' => '!=',
							'value' => 'Hide',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => 'I\'m',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'maxlength' => '',
				'readonly' => 0,
				'disabled' => 0,
			),
			array(
				'key' => 'field_564dc9404a97f',
				'label' => '2nd title field',
				'name' => 'second_title_field',
				'type' => 'text',
				'instructions' => 'Here you can type any text, for example your name',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_56c46da48b2d3',
							'operator' => '!=',
							'value' => 'Hide',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => 'Robert Smith',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'maxlength' => '',
				'readonly' => 0,
				'disabled' => 0,
			),
			array(
				'key' => 'field_564dc9874a980',
				'label' => 'Subtitle',
				'name' => 'subtitle',
				'type' => 'text',
				'instructions' => 'This text will appear under the title field',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_56c46da48b2d3',
							'operator' => '!=',
							'value' => 'Hide',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => 'Developer and businessman',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'maxlength' => '',
				'readonly' => 0,
				'disabled' => 0,
			),
			array(
				'key' => 'field_5a17fb5b15a45',
				'label' => 'About Description',
				'name' => 'about_description',
				'type' => 'select',
				'instructions' => 'Select which type of field group you want to use',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_56c46da48b2d3',
							'operator' => '!=',
							'value' => 'Hide',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'choices' => array(
					'repeater_fields' => 'Repeater Fields',
					'text_editor' => 'Text Editor',
				),
				'default_value' => array(
					0 => 'repeater_fields',
				),
				'allow_null' => 0,
				'multiple' => 0,
				'ui' => 0,
				'ajax' => 0,
				'return_format' => 'value',
				'placeholder' => '',
			),
			array(
				'key' => 'field_564dc9a94a981',
				'label' => 'About fields',
				'name' => 'about_fields',
				'type' => 'repeater',
				'instructions' => 'Here you can provide some information about yourself',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_56c46da48b2d3',
							'operator' => '!=',
							'value' => 'Hide',
						),
						array(
							'field' => 'field_5a17fb5b15a45',
							'operator' => '==',
							'value' => 'repeater_fields',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'collapsed' => '',
				'min' => 0,
				'max' => 0,
				'layout' => 'table',
				'button_label' => 'Add Row',
				'sub_fields' => array(
					array(
						'key' => 'field_564dc9d34a982',
						'label' => 'Field name',
						'name' => 'field_name',
						'type' => 'text',
						'instructions' => 'This is the about field name',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'maxlength' => '',
						'readonly' => 0,
						'disabled' => 0,
					),
					array(
						'key' => 'field_564dca0f4a983',
						'label' => 'Field value',
						'name' => 'field_value',
						'type' => 'text',
						'instructions' => 'This is the about field value',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'maxlength' => '',
						'readonly' => 0,
						'disabled' => 0,
					),
				),
			),
			array(
				'key' => 'field_5a17fef8f8863',
				'label' => 'About Editor',
				'name' => 'about_editor',
				'type' => 'wysiwyg',
				'instructions' => 'Type the text',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_56c46da48b2d3',
							'operator' => '!=',
							'value' => 'Hide',
						),
						array(
							'field' => 'field_5a17fb5b15a45',
							'operator' => '==',
							'value' => 'text_editor',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'tabs' => 'all',
				'toolbar' => 'full',
				'media_upload' => 1,
				'delay' => 0,
			),
			array(
				'key' => 'field_564dca404a984',
				'label' => 'Highlighted Textfiled Name',
				'name' => 'vacation',
				'type' => 'text',
				'instructions' => 'Please type the highlighted text name',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_56c46da48b2d3',
							'operator' => '!=',
							'value' => 'Hide',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => 'On Vacation',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'maxlength' => '',
				'readonly' => 0,
				'disabled' => 0,
			),
			array(
				'key' => 'field_56d58ae1f87c0',
				'label' => 'Highlighted Textfiled Info',
				'name' => 'vacation_info',
				'type' => 'text',
				'instructions' => 'Please type the text for the Highlighted Textfiled',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_56c46da48b2d3',
							'operator' => '!=',
							'value' => 'Hide',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => 'till April 15, 2016',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'maxlength' => '',
				'readonly' => 0,
				'disabled' => 0,
			),
			array(
				'key' => 'field_577f9651f556f',
				'label' => 'Highlighted Textfiled Icon',
				'name' => 'highlighted_textfiled_icon',
				'type' => 'text',
				'instructions' => 'Here you can type the icon for highlighted textfield:</br>
1. Please go to <a href="https://rscard.px-lab.com/html/icons.html" target="_blank">https://rscard.px-lab.com/html/icons.html</a></br>
2. Copy the icon you need and paste into "Icon" field',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_56c46da48b2d3',
							'operator' => '!=',
							'value' => 'Hide',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '<i class="rsicon rsicon-calendar"></i>',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'maxlength' => '',
			),
			array(
				'key' => 'field_564dca764a985',
				'label' => 'Enable Social Icons',
				'name' => 'enable_social_icons',
				'type' => 'checkbox',
				'instructions' => 'This checkbox have to be selected if you want the social icons to be seen',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_56c46da48b2d3',
							'operator' => '!=',
							'value' => 'Hide',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'choices' => array(
					'Enable' => 'Enable',
				),
				'default_value' => array(
					0 => 'Enable',
				),
				'layout' => 'vertical',
				'toggle' => 0,
				'allow_custom' => 0,
				'save_custom' => 0,
				'return_format' => 'value',
			),
			array(
				'key' => 'field_564dca994a986',
				'label' => 'Description Text',
				'name' => 'description_text',
				'type' => 'wysiwyg',
				'instructions' => 'Please type some words about you.',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_56c46da48b2d3',
							'operator' => '!=',
							'value' => 'Hide',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => 'Hello! I\'m Robert Smith Send tClaritas est etiam processus dynamicus, qui sequitur mutationem consuetudium lectorum. Mirum est notare quam littera gothica, quam nuncl them Toruk Macto calls to them!',
				'tabs' => 'all',
				'toolbar' => 'basic',
				'media_upload' => 1,
				'delay' => 0,
			),
			array(
				'key' => 'field_564dcac54a987',
				'label' => 'Button Attachment',
				'name' => 'resume_attachment',
				'type' => 'file',
				'instructions' => 'Please upload your resume here or type link below',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_56c46da48b2d3',
							'operator' => '!=',
							'value' => 'Hide',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'return_format' => 'url',
				'library' => 'all',
				'min_size' => '',
				'max_size' => '',
				'mime_types' => '',
			),
			array(
				'key' => 'field_56a0cfdea91f5',
				'label' => 'Button Link',
				'name' => 'button_link',
				'type' => 'text',
				'instructions' => 'Paste link here, which will work if file doesn\'t attached.',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_56c46da48b2d3',
							'operator' => '!=',
							'value' => 'Hide',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'maxlength' => '',
				'readonly' => 0,
				'disabled' => 0,
			),
			array(
				'key' => 'field_56a0d0aea91f6',
				'label' => 'Button Text',
				'name' => 'button_text',
				'type' => 'text',
				'instructions' => 'Please type button text',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_56c46da48b2d3',
							'operator' => '!=',
							'value' => 'Hide',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => 'Download Resume',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'maxlength' => '',
				'readonly' => 0,
				'disabled' => 0,
			),
			array(
				'key' => 'field_564dcae20ff53',
				'label' => 'Other Sections',
				'name' => '',
				'type' => 'tab',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'placement' => 'top',
				'endpoint' => 0,
			),
			array(
				'key' => 'field_564d9f1c144c5',
				'label' => 'Sections',
				'name' => 'sections',
				'type' => 'flexible_content',
				'instructions' => 'Please select the sections, which you want to sea on your homepage',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'button_label' => 'Add Row',
				'min' => '',
				'max' => '',
				'layouts' => array(
					array(
						'key' => '564db21daa1b9',
						'name' => 'skills_section',
						'label' => 'Skills Section',
						'display' => 'block',
						'sub_fields' => array(
							array(
								'key' => 'field_564db59fb6e0e',
								'label' => 'Section Title',
								'name' => 'section_title',
								'type' => 'text',
								'instructions' => 'Here you can type the section\'s title',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'Professional	Skills',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
							array(
								'key' => 'field_5820540ba9d6d',
								'label' => 'Disable The Background',
								'name' => 'disable_the_background',
								'type' => 'checkbox',
								'instructions' => 'Please select the checkbox if you want to disable the background for this section',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'choices' => array(
									'Disable' => 'Disable',
								),
								'default_value' => array(
								),
								'layout' => 'vertical',
								'toggle' => 0,
								'return_format' => 'value',
								'allow_custom' => 0,
								'save_custom' => 0,
							),
							array(
								'key' => 'field_564db23baa1ba',
								'label' => 'Skill',
								'name' => 'skill',
								'type' => 'repeater',
								'instructions' => '',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'collapsed' => '',
								'min' => 0,
								'max' => 0,
								'layout' => 'table',
								'button_label' => 'Add Row',
								'sub_fields' => array(
									array(
										'key' => 'field_564db250aa1bb',
										'label' => 'Title',
										'name' => 'title',
										'type' => 'text',
										'instructions' => 'Please type skill title',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
									array(
										'key' => 'field_564db276aa1bc',
										'label' => 'Percent For Bar',
										'name' => 'percent',
										'type' => 'number',
										'instructions' => 'Please type skill bar percent',
										'required' => 1,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'min' => 0,
										'max' => 100,
										'step' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
									array(
										'key' => 'field_57838643b3fe3',
										'label' => 'Value',
										'name' => 'value',
										'type' => 'text',
										'instructions' => 'Please type the value for percent bar',
										'required' => '',
										'conditional_logic' => '',
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
								),
							),
							array(
								'key' => 'field_569e3a062a1ec',
								'label' => 'Custom Editor',
								'name' => 'custom_editor',
								'type' => 'wysiwyg',
								'instructions' => 'You can put here any custom text.',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => '',
								'tabs' => 'all',
								'toolbar' => 'full',
								'media_upload' => 1,
								'delay' => 0,
							),
							array(
								'key' => 'field_5680df92a8f36',
								'label' => 'Menu Id',
								'name' => 'menu_id',
								'type' => 'text',
								'instructions' => 'Please put here the unique id, which will be used for menu',
								'required' => 1,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'skills',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
						),
						'min' => '',
						'max' => '',
					),
					array(
						'key' => '564dc4a957354',
						'name' => 'interests_section',
						'label' => 'Interests Section',
						'display' => 'block',
						'sub_fields' => array(
							array(
								'key' => 'field_564dd4801fbc7',
								'label' => 'Section Title',
								'name' => 'section_title',
								'type' => 'text',
								'instructions' => 'Here you can type the section\'s title',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'My Interests',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
							array(
								'key' => 'field_58205490a9d6e',
								'label' => 'Disable The Background',
								'name' => 'disable_the_background',
								'type' => 'checkbox',
								'instructions' => 'Please select the checkbox if you want to disable the background for this section',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'choices' => array(
									'Disable' => 'Disable',
								),
								'default_value' => array(
								),
								'layout' => 'vertical',
								'toggle' => 0,
								'return_format' => 'value',
								'allow_custom' => 0,
								'save_custom' => 0,
							),
							array(
								'key' => 'field_564dc4c157355',
								'label' => 'Description',
								'name' => 'description',
								'type' => 'wysiwyg',
								'instructions' => 'This is some custom content area',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => '',
								'tabs' => 'all',
								'toolbar' => 'full',
								'media_upload' => 1,
								'delay' => 0,
							),
							array(
								'key' => 'field_569cc70ce57e7',
								'label' => 'Interests',
								'name' => 'interests',
								'type' => 'repeater',
								'instructions' => 'Here you can type your interests using "Map Icons":</br>
1. Please go to <a href="http://map-icons.com/#icons" target="_blank">http://map-icons.com/#icons</a></br>
2. Copy the icon name you need and paste into "class" field (e.g. map-icon-route)',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'collapsed' => '',
								'min' => 0,
								'max' => 0,
								'layout' => 'table',
								'button_label' => 'Add Row',
								'sub_fields' => array(
									array(
										'key' => 'field_569cc725e57e8',
										'label' => 'Interest Name',
										'name' => 'interest_name',
										'type' => 'text',
										'instructions' => 'This is the Interest\'s name, which will eppear under the icon',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
									array(
										'key' => 'field_569cc73ee57e9',
										'label' => 'Interest Class',
										'name' => 'interest_class',
										'type' => 'text',
										'instructions' => 'Please paste here the icon name',
										'required' => 1,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
								),
							),
							array(
								'key' => 'field_569e3a432a1ed',
								'label' => 'Custom Editor',
								'name' => 'custom_editor',
								'type' => 'wysiwyg',
								'instructions' => 'You can put here any custom text.',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => '',
								'tabs' => 'all',
								'toolbar' => 'full',
								'media_upload' => 1,
								'delay' => 0,
							),
							array(
								'key' => 'field_56827367534d8',
								'label' => 'Menu Id',
								'name' => 'menu_id',
								'type' => 'text',
								'instructions' => 'Please put here the unique id, which will be used for menu',
								'required' => 1,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'interests',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
						),
						'min' => '',
						'max' => '',
					),
					array(
						'key' => '564eeab3e4888',
						'name' => 'experience_section',
						'label' => 'Experience Section',
						'display' => 'block',
						'sub_fields' => array(
							array(
								'key' => 'field_564eeaece4889',
								'label' => 'Section Title',
								'name' => 'section_title',
								'type' => 'text',
								'instructions' => 'Here you can type the section\'s title',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'Work Experience',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
							array(
								'key' => 'field_564eeb11e488a',
								'label' => 'Experiences',
								'name' => 'experiences',
								'type' => 'repeater',
								'instructions' => 'Here you can add your work experiences',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'collapsed' => '',
								'min' => 0,
								'max' => 0,
								'layout' => 'table',
								'button_label' => 'Add Row',
								'sub_fields' => array(
									array(
										'key' => 'field_564eeb5ce488c',
										'label' => 'Years',
										'name' => 'years',
										'type' => 'text',
										'instructions' => '',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'maxlength' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
									array(
										'key' => 'field_564eeb8ce488d',
										'label' => 'Field 1',
										'name' => 'position',
										'type' => 'text',
										'instructions' => 'If you type position in Field 1, then you need to type workplace in Field 2',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => 'UI & Web Designer',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
									array(
										'key' => 'field_56d580886453a',
										'label' => 'Field 1 Link',
										'name' => 'position_link',
										'type' => 'text',
										'instructions' => 'You can insert the link for Field 1',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
									array(
										'key' => 'field_5836d69b5d7ca',
										'label' => 'Image',
										'name' => 'image',
										'type' => 'image',
										'instructions' => 'Here you can upload the image',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'return_format' => 'array',
										'preview_size' => 'thumbnail',
										'library' => 'all',
										'min_width' => '',
										'min_height' => '',
										'min_size' => '',
										'max_width' => '',
										'max_height' => '',
										'max_size' => '',
										'mime_types' => '',
									),
									array(
										'key' => 'field_5836d6685d7c9',
										'label' => 'Image Link',
										'name' => 'image_link',
										'type' => 'text',
										'instructions' => 'Here you can put the image link',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
									),
									array(
										'key' => 'field_564eec17e488e',
										'label' => 'Field 2',
										'name' => 'workplace',
										'type' => 'text',
										'instructions' => 'If you type position in Field 2, then you need to type workplace in Field 1',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => 'Company Name',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
									array(
										'key' => 'field_564eec5de488f',
										'label' => 'Description',
										'name' => 'description',
										'type' => 'textarea',
										'instructions' => 'Tell something about this experience',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'maxlength' => '',
										'rows' => '',
										'new_lines' => 'wpautop',
										'readonly' => 0,
										'disabled' => 0,
									),
								),
							),
							array(
								'key' => 'field_569e3a5a2a1ee',
								'label' => 'Custom Editor',
								'name' => 'custom_editor',
								'type' => 'wysiwyg',
								'instructions' => 'You can put here any custom text.',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => '',
								'tabs' => 'all',
								'toolbar' => 'full',
								'media_upload' => 1,
								'delay' => 0,
							),
							array(
								'key' => 'field_569cc776e57ea',
								'label' => 'Menu Id',
								'name' => 'menu_id',
								'type' => 'text',
								'instructions' => 'Please put here the unique id, which will be used for menu',
								'required' => 1,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'experience',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
						),
						'min' => '',
						'max' => '',
					),
					array(
						'key' => '564ef0cc652c2',
						'name' => 'education_section',
						'label' => 'Education Section',
						'display' => 'block',
						'sub_fields' => array(
							array(
								'key' => 'field_564ef173652c3',
								'label' => 'Section Title',
								'name' => 'section_title',
								'type' => 'text',
								'instructions' => 'Here you can type the section\'s title',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'Education',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
							array(
								'key' => 'field_564ef192652c4',
								'label' => 'Education Fields',
								'name' => 'education_fields',
								'type' => 'repeater',
								'instructions' => '',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'collapsed' => '',
								'min' => 0,
								'max' => 0,
								'layout' => 'table',
								'button_label' => 'Add Row',
								'sub_fields' => array(
									array(
										'key' => 'field_564ef1c9652c5',
										'label' => 'Years',
										'name' => 'years',
										'type' => 'text',
										'instructions' => '',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'maxlength' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
									array(
										'key' => 'field_564ef213652c6',
										'label' => 'Education Name',
										'name' => 'education_name',
										'type' => 'text',
										'instructions' => 'Type the specialization or degree or education name',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => 'UI & Web Designer',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
									array(
										'key' => 'field_5836d6cb5d7cb',
										'label' => 'Image',
										'name' => 'image',
										'type' => 'image',
										'instructions' => 'Here you can upload the image',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'return_format' => 'array',
										'preview_size' => 'thumbnail',
										'library' => 'all',
										'min_width' => '',
										'min_height' => '',
										'min_size' => '',
										'max_width' => '',
										'max_height' => '',
										'max_size' => '',
										'mime_types' => '',
									),
									array(
										'key' => 'field_5836d6d85d7cc',
										'label' => 'Image Link',
										'name' => 'image_link',
										'type' => 'text',
										'instructions' => 'Here you can put the image link',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
									),
									array(
										'key' => 'field_564ef257652c7',
										'label' => 'Education Place',
										'name' => 'education_place',
										'type' => 'text',
										'instructions' => 'Type the university name or education place',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => 'Education Place Name',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
									array(
										'key' => 'field_56d580e56453b',
										'label' => 'Education Place Link',
										'name' => 'education_place_link',
										'type' => 'text',
										'instructions' => 'The link field for Education Place',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
								),
							),
							array(
								'key' => 'field_569e3a6f2a1ef',
								'label' => 'Custom Editor',
								'name' => 'custom_editor',
								'type' => 'wysiwyg',
								'instructions' => 'You can put here any custom text.',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => '',
								'tabs' => 'all',
								'toolbar' => 'full',
								'media_upload' => 1,
								'delay' => 0,
							),
							array(
								'key' => 'field_569cc78ce57eb',
								'label' => 'Menu Id',
								'name' => 'menu_id',
								'type' => 'text',
								'instructions' => 'Please put here the unique id, which will be used for menu',
								'required' => 1,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'education',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
						),
						'min' => '',
						'max' => '',
					),
					array(
						'key' => '564f09b90d184',
						'name' => 'references_section',
						'label' => 'References Section',
						'display' => 'block',
						'sub_fields' => array(
							array(
								'key' => 'field_564f09ee0d185',
								'label' => 'Section Title',
								'name' => 'section_title',
								'type' => 'text',
								'instructions' => 'Here you can type the section\'s title',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'References',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
							array(
								'key' => 'field_582055f6a9d71',
								'label' => 'Disable The Background',
								'name' => 'disable_the_background',
								'type' => 'checkbox',
								'instructions' => 'Please select the checkbox if you want to disable the background for this section',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'choices' => array(
									'Disable' => 'Disable',
								),
								'default_value' => array(
								),
								'layout' => 'vertical',
								'toggle' => 0,
								'return_format' => 'value',
								'allow_custom' => 0,
								'save_custom' => 0,
							),
							array(
								'key' => 'field_5b069ebdb585a',
								'label' => 'Turn Adaptive Height On',
								'name' => 'adaptive_height',
								'type' => 'checkbox',
								'instructions' => 'Select the checkbox to turn on the slider\'s adaptive height',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '50',
									'class' => '',
									'id' => '',
								),
								'choices' => array(
									'on' => 'On',
								),
								'allow_custom' => 0,
								'save_custom' => 0,
								'default_value' => array(
									0 => 'on',
								),
								'layout' => 'vertical',
								'toggle' => 0,
								'return_format' => 'value',
							),
							array(
								'key' => 'field_5b069f6eb585b',
								'label' => 'Turn Auto Rotate On',
								'name' => 'turn_auto_rotate_on',
								'type' => 'checkbox',
								'instructions' => 'Select the checkbox to turn on the slider\'s auto rotate',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '50',
									'class' => '',
									'id' => '',
								),
								'choices' => array(
									'on' => 'On',
								),
								'allow_custom' => 0,
								'save_custom' => 0,
								'default_value' => array(
									0 => 'on',
								),
								'layout' => 'vertical',
								'toggle' => 0,
								'return_format' => 'value',
							),
							array(
								'key' => 'field_564f0a160d186',
								'label' => 'References',
								'name' => 'references',
								'type' => 'repeater',
								'instructions' => 'Here you can add references',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'collapsed' => '',
								'min' => 0,
								'max' => 0,
								'layout' => 'table',
								'button_label' => 'Add Row',
								'sub_fields' => array(
									array(
										'key' => 'field_564f0a590d187',
										'label' => 'Quote',
										'name' => 'quote',
										'type' => 'textarea',
										'instructions' => 'Please write the quote here',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'maxlength' => '',
										'rows' => '',
										'new_lines' => 'wpautop',
										'readonly' => 0,
										'disabled' => 0,
									),
									array(
										'key' => 'field_564f0a910d188',
										'label' => 'Author Thumbnail',
										'name' => 'author_thumbnail',
										'type' => 'image',
										'instructions' => 'You can attach the author\'s thumbnail here (53x53)',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'return_format' => 'array',
										'preview_size' => 'thumbnail',
										'library' => 'all',
										'min_width' => '',
										'min_height' => '',
										'min_size' => '',
										'max_width' => '',
										'max_height' => '',
										'max_size' => '',
										'mime_types' => '',
									),
									array(
										'key' => 'field_564f0b3a0d189',
										'label' => 'Author Name',
										'name' => 'author_name',
										'type' => 'text',
										'instructions' => 'Type the author\'s name',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => 'Alexander Jokovich',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
									array(
										'key' => 'field_56d5835e1ef48',
										'label' => 'Author Link',
										'name' => 'author_link',
										'type' => 'text',
										'instructions' => 'You can put here the link for Author Name and Author Thumbnail fields',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
									array(
										'key' => 'field_564f0ba30d18a',
										'label' => 'Author Position',
										'name' => 'author_position',
										'type' => 'text',
										'instructions' => 'Type author\'s position here',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => 'MODERN LLC , HR',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
								),
							),
							array(
								'key' => 'field_56d7df24ac29d',
								'label' => 'Slide Speed',
								'name' => 'slide_speed',
								'type' => 'number',
								'instructions' => 'Please type the slider speed in seconds',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 8,
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'min' => '',
								'max' => '',
								'step' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
							array(
								'key' => 'field_569e3a842a1f0',
								'label' => 'Custom Editor',
								'name' => 'custom_editor',
								'type' => 'wysiwyg',
								'instructions' => 'You can put here any custom text.',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => '',
								'tabs' => 'all',
								'toolbar' => 'full',
								'media_upload' => 1,
								'delay' => 0,
							),
							array(
								'key' => 'field_569cc7d2e57ec',
								'label' => 'Menu Id',
								'name' => 'menu_id',
								'type' => 'text',
								'instructions' => 'Please put here the unique id, which will be used for menu',
								'required' => 1,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'references',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
						),
						'min' => '',
						'max' => '',
					),
					array(
						'key' => '564f157828524',
						'name' => 'calendar_section',
						'label' => 'Calendar Section',
						'display' => 'block',
						'sub_fields' => array(
							array(
								'key' => 'field_564f158e28525',
								'label' => 'Section Title',
								'name' => 'section_title',
								'type' => 'text',
								'instructions' => 'Here you can type the section\'s title',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'Availability Calendar',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
							array(
								'key' => 'field_56d58702a0a0c',
								'label' => 'Disable The Background',
								'name' => 'disable_the_background',
								'type' => 'checkbox',
								'instructions' => 'Please select the checkbox if you want to disable the background for this section',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'choices' => array(
									'Disable' => 'Disable',
								),
								'default_value' => array(
								),
								'layout' => 'vertical',
								'toggle' => 0,
								'return_format' => 'value',
								'allow_custom' => 0,
								'save_custom' => 0,
							),
							array(
								'key' => 'field_58207959da81d',
								'label' => 'Section Background',
								'name' => 'section_background',
								'type' => 'image',
								'instructions' => 'Here you can upload the image, which will override the section\'s background image',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'return_format' => 'url',
								'preview_size' => 'thumbnail',
								'library' => 'all',
								'min_width' => '',
								'min_height' => '',
								'min_size' => '',
								'max_width' => '',
								'max_height' => '',
								'max_size' => '',
								'mime_types' => '',
							),
							array(
								'key' => 'field_564f15be28526',
								'label' => 'Busy Days',
								'name' => 'busy_days',
								'type' => 'repeater',
								'instructions' => 'Here you can select your busy days',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'collapsed' => '',
								'min' => 1,
								'max' => 0,
								'layout' => 'table',
								'button_label' => 'Add Row',
								'sub_fields' => array(
									array(
										'key' => 'field_564f15f328527',
										'label' => 'Busy Day',
										'name' => 'busy_day',
										'type' => 'date_picker',
										'instructions' => 'Please select the busy day',
										'required' => 1,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'display_format' => 'd/m/Y',
										'return_format' => 'Y, m, d',
										'first_day' => 1,
									),
								),
							),
							array(
								'key' => 'field_564f166f28528',
								'label' => 'Busy Message',
								'name' => 'busy_message',
								'type' => 'text',
								'instructions' => 'Here you can type your message for busy days',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'Sorry. I\'m not available on those days',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
							array(
								'key' => 'field_569cc821e57ee',
								'label' => 'Week Start',
								'name' => 'week_start',
								'type' => 'checkbox',
								'instructions' => 'Please select the checkbox if you want the week to start from monday',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'choices' => array(
									'Start From Monday' => 'Start From Monday',
								),
								'default_value' => array(
								),
								'layout' => 'vertical',
								'toggle' => 0,
								'allow_custom' => 0,
								'save_custom' => 0,
								'return_format' => 'value',
							),
							array(
								'key' => 'field_569e3a982a1f1',
								'label' => 'Custom Editor',
								'name' => 'custom_editor',
								'type' => 'wysiwyg',
								'instructions' => 'You can put here any custom text.',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => '',
								'tabs' => 'all',
								'toolbar' => 'full',
								'media_upload' => 1,
								'delay' => 0,
							),
							array(
								'key' => 'field_569cc7f1e57ed',
								'label' => 'Menu Id',
								'name' => 'menu_id',
								'type' => 'text',
								'instructions' => 'Please put here the unique id, which will be used for menu',
								'required' => 1,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'calendar',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
						),
						'min' => '',
						'max' => 1,
					),
					array(
						'key' => '56546347f961c',
						'name' => 'blog_section',
						'label' => 'Blog Section',
						'display' => 'block',
						'sub_fields' => array(
							array(
								'key' => 'field_5654635ff961d',
								'label' => 'Section Title',
								'name' => 'section_title',
								'type' => 'text',
								'instructions' => 'Here you can type the section\'s title',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'From The Blog',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
							array(
								'key' => 'field_56546372f961e',
								'label' => 'Post\'s Count',
								'name' => 'posts_count',
								'type' => 'select',
								'instructions' => 'Here you can select how many posts to be shown on your page',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'choices' => array(
									2 => '2',
									4 => '4',
									6 => '6',
									8 => '8',
								),
								'default_value' => array(
								),
								'allow_null' => 0,
								'multiple' => 0,
								'ui' => 0,
								'ajax' => 0,
								'placeholder' => '',
								'disabled' => 0,
								'readonly' => 0,
								'return_format' => 'value',
							),
							array(
								'key' => 'field_5680e41533226',
								'label' => 'Post Categories',
								'name' => 'post_categories',
								'type' => 'taxonomy',
								'instructions' => 'Please select the categories you want',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'taxonomy' => 'category',
								'field_type' => 'multi_select',
								'allow_null' => 0,
								'add_term' => 1,
								'save_terms' => 0,
								'load_terms' => 0,
								'return_format' => 'id',
								'multiple' => 0,
							),
							array(
								'key' => 'field_569e3ab62a1f2',
								'label' => 'Custom Editor',
								'name' => 'custom_editor',
								'type' => 'wysiwyg',
								'instructions' => 'You can put here any custom text.',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => '',
								'tabs' => 'all',
								'toolbar' => 'full',
								'media_upload' => 1,
								'delay' => 0,
							),
							array(
								'key' => 'field_569cc84be57ef',
								'label' => 'Menu Id',
								'name' => 'menu_id',
								'type' => 'text',
								'instructions' => 'Please put here the unique id, which will be used for menu',
								'required' => 1,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'blog',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
						),
						'min' => '',
						'max' => '',
					),
					array(
						'key' => '565ecefc1a2d4',
						'name' => 'portfolio_section',
						'label' => 'Portfolio Section',
						'display' => 'block',
						'sub_fields' => array(
							array(
								'key' => 'field_565ecefc1a2d5',
								'label' => 'Section Title',
								'name' => 'section_title',
								'type' => 'text',
								'instructions' => 'Here you can type the section\'s title',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'Portfolio',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
							array(
								'key' => 'field_58205abea9d73',
								'label' => 'Disable The Background',
								'name' => 'disable_the_background',
								'type' => 'checkbox',
								'instructions' => 'Here you can upload the image, which will override the section\'s background image',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'choices' => array(
									'Disable' => 'Disable',
								),
								'default_value' => array(
									0 => 'Disable',
								),
								'layout' => 'vertical',
								'toggle' => 0,
								'return_format' => 'value',
								'allow_custom' => 0,
								'save_custom' => 0,
							),
							array(
								'key' => 'field_58206d41c79a6',
								'label' => 'Display Type',
								'name' => 'display_type',
								'type' => 'select',
								'instructions' => 'Please select the display type for portfolio section',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'choices' => array(
									'grid' => 'Grid',
									'slider' => 'Slider',
								),
								'default_value' => array(
								),
								'allow_null' => 0,
								'multiple' => 0,
								'ui' => 0,
								'ajax' => 0,
								'return_format' => 'value',
								'placeholder' => '',
							),
							array(
								'key' => 'field_56a0b9f4c34ba',
								'label' => 'Post\'s Count',
								'name' => 'posts_count',
								'type' => 'number',
								'instructions' => 'Here you can select how many posts to be shown on your page',
								'required' => 1,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 9,
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'min' => 3,
								'max' => 100,
								'step' => '',
							),
							array(
								'key' => 'field_56822f641dd7a',
								'label' => 'Portfolio Categories',
								'name' => 'portfolio_categories',
								'type' => 'taxonomy',
								'instructions' => 'Please select the categories you want',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'taxonomy' => 'portfolio_categories',
								'field_type' => 'multi_select',
								'allow_null' => 1,
								'add_term' => 0,
								'save_terms' => 0,
								'load_terms' => 0,
								'return_format' => 'id',
								'multiple' => 0,
							),
							array(
								'key' => 'field_5820275422a89',
								'label' => 'Popup Style',
								'name' => 'popup_style',
								'type' => 'select',
								'instructions' => 'Please select the popup style',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'choices' => array(
									'single_popup' => 'Single Project Popup',
									'cross_popup' => 'Cross Project Popup',
								),
								'default_value' => array(
									0 => 'Single Project Popup',
								),
								'allow_null' => 0,
								'multiple' => 0,
								'ui' => 0,
								'ajax' => 0,
								'return_format' => 'value',
								'placeholder' => '',
							),
							array(
								'key' => 'field_56a0bdcfc34bc',
								'label' => 'More Button Items Count',
								'name' => 'more_button_items_count',
								'type' => 'number',
								'instructions' => 'Select how many portfolio posts do you want to show after clicking on more button',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 3,
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'min' => 1,
								'max' => 9,
								'step' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
							array(
								'key' => 'field_56a0bb35c34bb',
								'label' => 'Disable More Button',
								'name' => 'disable_more_button',
								'type' => 'checkbox',
								'instructions' => 'Select the checkbox if you want to disable the more button.',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'choices' => array(
									'Disable' => 'Disable',
								),
								'default_value' => array(
								),
								'layout' => 'vertical',
								'toggle' => 0,
								'allow_custom' => 0,
								'save_custom' => 0,
								'return_format' => 'value',
							),
							array(
								'key' => 'field_569e3aca2a1f3',
								'label' => 'Custom Editor',
								'name' => 'custom_editor',
								'type' => 'wysiwyg',
								'instructions' => 'You can put here any custom text.',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => '',
								'tabs' => 'all',
								'toolbar' => 'full',
								'media_upload' => 1,
								'delay' => 0,
							),
							array(
								'key' => 'field_569cc86ee57f0',
								'label' => 'Menu Id',
								'name' => 'menu_id',
								'type' => 'text',
								'instructions' => 'Please put here the unique id, which will be used for menu',
								'required' => 1,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'portfolio',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
						),
						'min' => '',
						'max' => '',
					),
					array(
						'key' => '5654674f67d35',
						'name' => 'contact_section',
						'label' => 'Contact Section',
						'display' => 'block',
						'sub_fields' => array(
							array(
								'key' => 'field_5654676867d36',
								'label' => 'Section Title',
								'name' => 'section_title',
								'type' => 'text',
								'instructions' => 'Here you can type the section\'s title',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'Contact Us',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
							array(
								'key' => 'field_5654679c67d37',
								'label' => 'Contact Form Block',
								'name' => '',
								'type' => 'tab',
								'instructions' => '',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'placement' => 'top',
								'endpoint' => 0,
							),
							array(
								'key' => 'field_565467be67d38',
								'label' => 'Contact Form Title',
								'name' => 'contact_form_title',
								'type' => 'text',
								'instructions' => 'Here you can type some title for contact form',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'FEEL FREE TO CONTACT ME',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
							array(
								'key' => 'field_565467eb67d39',
								'label' => 'Contact Form Shortcode',
								'name' => 'contact_form_shortcode',
								'type' => 'text',
								'instructions' => 'Please put here "Contact Form" shortcode',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => '[rs_card_contact_form]',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
							array(
								'key' => 'field_5654682a67d3a',
								'label' => 'Map/Info Block',
								'name' => '',
								'type' => 'tab',
								'instructions' => '',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'placement' => 'top',
								'endpoint' => 0,
							),
							array(
								'key' => 'field_56b056640409f',
								'label' => 'Contact Fields',
								'name' => 'contact_fields',
								'type' => 'repeater',
								'instructions' => 'You can create your own contact fields</br>
Use this code for adding phone numbers: 
&lt;a href="tel:+12562548456"&gt;+1 256 254 84 56&lt;/a&gt;</br>
Use this code for adding email: 
&lt;a href="mailto:robertsmith@company.com"&gt;robertsmith@company.com&lt;/a&gt;',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'collapsed' => '',
								'min' => 0,
								'max' => 0,
								'layout' => 'table',
								'button_label' => 'Add Row',
								'sub_fields' => array(
									array(
										'key' => 'field_56b056b6040a0',
										'label' => 'Field Name',
										'name' => 'name',
										'type' => 'text',
										'instructions' => 'Please type the field name',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
									array(
										'key' => 'field_56b0573d040a1',
										'label' => 'Field Value',
										'name' => 'value',
										'type' => 'textarea',
										'instructions' => 'Please type the field value',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'maxlength' => '',
										'rows' => '',
										'new_lines' => 'br',
										'readonly' => 0,
										'disabled' => 0,
									),
								),
							),
							array(
								'key' => 'field_5654696e67d3e',
								'label' => 'Google Map Latitude',
								'name' => 'google_map_latitude',
								'type' => 'text',
								'instructions' => 'Please put Google Map latitude here',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => '50.84592',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
							array(
								'key' => 'field_565469a467d3f',
								'label' => 'Google Map Longitude',
								'name' => 'google_map_longitude',
								'type' => 'text',
								'instructions' => 'Please put Google Map longitude here',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => '4.366859999999974',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
							array(
								'key' => 'field_569e3ae12a1f4',
								'label' => 'Custom Editor',
								'name' => 'custom_editor',
								'type' => 'wysiwyg',
								'instructions' => 'You can put here any custom text.',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => '',
								'tabs' => 'all',
								'toolbar' => 'full',
								'media_upload' => 1,
								'delay' => 0,
							),
							array(
								'key' => 'field_569cc893e57f1',
								'label' => 'Menu Id',
								'name' => 'menu_id',
								'type' => 'text',
								'instructions' => 'Please put here the unique id, which will be used for menu',
								'required' => 1,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'contact',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
						),
						'min' => '',
						'max' => 1,
					),
					array(
						'key' => '5673daa8f30de',
						'name' => 'clients_section',
						'label' => 'Clients Section',
						'display' => 'block',
						'sub_fields' => array(
							array(
								'key' => 'field_5673dac9f30df',
								'label' => 'Section Title',
								'name' => 'section_title',
								'type' => 'text',
								'instructions' => 'Here you can type the section\'s title',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'My Clients',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
							array(
								'key' => 'field_58205b0aa9d75',
								'label' => 'Disable The Background',
								'name' => 'disable_the_background',
								'type' => 'checkbox',
								'instructions' => 'Here you can upload the image, which will override the section\'s background image',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'choices' => array(
									'Disable' => 'Disable',
								),
								'default_value' => array(
									0 => 'Disable',
								),
								'layout' => 'vertical',
								'toggle' => 0,
								'return_format' => 'value',
								'allow_custom' => 0,
								'save_custom' => 0,
							),
							array(
								'key' => 'field_5673dae8f30e0',
								'label' => 'Clients',
								'name' => 'clients',
								'type' => 'repeater',
								'instructions' => 'Here you can add your clients',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'collapsed' => '',
								'min' => 0,
								'max' => 0,
								'layout' => 'table',
								'button_label' => 'Add Row',
								'sub_fields' => array(
									array(
										'key' => 'field_5673db2af30e1',
										'label' => 'Image',
										'name' => 'image',
										'type' => 'image',
										'instructions' => 'Please upload client image',
										'required' => 1,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'return_format' => 'array',
										'preview_size' => 'thumbnail',
										'library' => 'all',
										'min_width' => '',
										'min_height' => '',
										'min_size' => '',
										'max_width' => '',
										'max_height' => '',
										'max_size' => '',
										'mime_types' => '',
									),
									array(
										'key' => 'field_5673db6df30e2',
										'label' => 'Url',
										'name' => 'url',
										'type' => 'text',
										'instructions' => 'You can put here image url',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
								),
							),
							array(
								'key' => 'field_569e3af22a1f5',
								'label' => 'Custom Editor',
								'name' => 'custom_editor',
								'type' => 'wysiwyg',
								'instructions' => 'You can put here any custom text.',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => '',
								'tabs' => 'all',
								'toolbar' => 'full',
								'media_upload' => 1,
								'delay' => 0,
							),
							array(
								'key' => 'field_569cc8fee57f2',
								'label' => 'Menu Id',
								'name' => 'menu_id',
								'type' => 'text',
								'instructions' => 'Please put here the unique id, which will be used for menu',
								'required' => 1,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'clients',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
						),
						'min' => '',
						'max' => '',
					),
					array(
						'key' => '5673e12e87583',
						'name' => 'price_box',
						'label' => 'Price Box',
						'display' => 'block',
						'sub_fields' => array(
							array(
								'key' => 'field_5673e14f87584',
								'label' => 'Section Title',
								'name' => 'section_title',
								'type' => 'text',
								'instructions' => 'Here you can type the section\'s title',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'Price List',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
							array(
								'key' => 'field_5673ea0887586',
								'label' => 'Boxes',
								'name' => 'boxes',
								'type' => 'repeater',
								'instructions' => 'Here you can add price boxes',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'collapsed' => '',
								'min' => 0,
								'max' => 0,
								'layout' => 'row',
								'button_label' => 'Add Row',
								'sub_fields' => array(
									array(
										'key' => 'field_5673ef05425de',
										'label' => 'Primary Box',
										'name' => 'primary_box',
										'type' => 'checkbox',
										'instructions' => 'Select the checkbox if you wna the box to be primary',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'choices' => array(
											'Primary' => 'Primary',
										),
										'default_value' => array(
										),
										'layout' => 'vertical',
										'toggle' => 0,
										'allow_custom' => 0,
										'save_custom' => 0,
										'return_format' => 'value',
									),
									array(
										'key' => 'field_5673ea4187587',
										'label' => 'Primary Price',
										'name' => 'primary_price',
										'type' => 'text',
										'instructions' => 'This is the price field',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
									array(
										'key' => 'field_5673f25f4b7a1',
										'label' => 'Secondary Price or Plan',
										'name' => 'secondary_price',
										'type' => 'text',
										'instructions' => '',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'maxlength' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
									array(
										'key' => 'field_5673ea7787588',
										'label' => 'Title',
										'name' => 'title',
										'type' => 'text',
										'instructions' => 'This is the box title',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
									array(
										'key' => 'field_5673ea9187589',
										'label' => 'Description',
										'name' => 'description',
										'type' => 'wysiwyg',
										'instructions' => 'Here you can write description for price box',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'tabs' => 'all',
										'toolbar' => 'basic',
										'media_upload' => 1,
										'delay' => 0,
									),
									array(
										'key' => 'field_5673eafc8758a',
										'label' => 'Button Text',
										'name' => 'button_text',
										'type' => 'text',
										'instructions' => 'You can write the text on button',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => 'Buy Now',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
									array(
										'key' => 'field_5673eb5d8758b',
										'label' => 'Button Url',
										'name' => 'button_url',
										'type' => 'text',
										'instructions' => 'You can put button link here',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '#',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
								),
							),
							array(
								'key' => 'field_569e3b0a2a1f6',
								'label' => 'Custom Editor',
								'name' => 'custom_editor',
								'type' => 'wysiwyg',
								'instructions' => 'You can put here any custom text.',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => '',
								'tabs' => 'all',
								'toolbar' => 'full',
								'media_upload' => 1,
								'delay' => 0,
							),
							array(
								'key' => 'field_569cc92be57f3',
								'label' => 'Menu Id',
								'name' => 'menu_id',
								'type' => 'text',
								'instructions' => 'Please put here the unique id, which will be used for menu',
								'required' => 1,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'prices',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
						),
						'min' => '',
						'max' => '',
					),
					array(
						'key' => '568f9bdf19a9b',
						'name' => 'editor_section',
						'label' => 'Editor Section',
						'display' => 'block',
						'sub_fields' => array(
							array(
								'key' => 'field_568f9bf519a9c',
								'label' => 'Section Title',
								'name' => 'section_title',
								'type' => 'text',
								'instructions' => 'Here you can type the section\'s title',
								'required' => '',
								'conditional_logic' => '',
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'Text Section',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
							array(
								'key' => 'field_58205b51a9d77',
								'label' => 'Disable The Background',
								'name' => 'disable_the_background',
								'type' => 'checkbox',
								'instructions' => 'Here you can upload the image, which will override the section\'s background image',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'choices' => array(
									'Disable' => 'Disable',
								),
								'default_value' => array(
								),
								'layout' => 'vertical',
								'toggle' => 0,
								'return_format' => 'value',
								'allow_custom' => 0,
								'save_custom' => 0,
							),
							array(
								'key' => 'field_568f9c1819a9d',
								'label' => 'Editor',
								'name' => 'editor',
								'type' => 'wysiwyg',
								'instructions' => 'Use this field if you want to output some editor content.',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => '',
								'tabs' => 'all',
								'toolbar' => 'full',
								'media_upload' => 1,
								'delay' => 0,
							),
							array(
								'key' => 'field_569e3b252a1f7',
								'label' => 'Custom Editor',
								'name' => 'custom_editor',
								'type' => 'wysiwyg',
								'instructions' => 'You can put here any custom text.',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => '',
								'tabs' => 'all',
								'toolbar' => 'full',
								'media_upload' => 1,
								'delay' => 0,
							),
							array(
								'key' => 'field_568f9dff9131c',
								'label' => 'Menu Id',
								'name' => 'menu_id',
								'type' => 'text',
								'instructions' => 'Please put here the unique id, which will be used for menu',
								'required' => 1,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'text_section',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
						),
						'min' => '',
						'max' => '',
					),
					array(
						'key' => '575944b627a13',
						'name' => 'statistics_section',
						'label' => 'Statistics Section',
						'display' => 'block',
						'sub_fields' => array(
							array(
								'key' => 'field_575944da27a14',
								'label' => 'Section Title',
								'name' => 'section_title',
								'type' => 'text',
								'instructions' => 'Here you can type the section\'s title',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'Any Statistics',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
							),
							array(
								'key' => 'field_58205b70a9d78',
								'label' => 'Disable The Background',
								'name' => 'disable_the_background',
								'type' => 'checkbox',
								'instructions' => 'Here you can upload the image, which will override the section\'s background image',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'choices' => array(
									'Disable' => 'Disable',
								),
								'default_value' => array(
									0 => 'Disable',
								),
								'layout' => 'vertical',
								'toggle' => 0,
								'return_format' => 'value',
								'allow_custom' => 0,
								'save_custom' => 0,
							),
							array(
								'key' => 'field_575946ed27a15',
								'label' => 'Statistics',
								'name' => 'statistics',
								'type' => 'repeater',
								'instructions' => 'Here you can add your statistics',
								'required' => 1,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'collapsed' => '',
								'min' => 0,
								'max' => 0,
								'layout' => 'table',
								'button_label' => 'Add Row',
								'sub_fields' => array(
									array(
										'key' => 'field_5759471827a16',
										'label' => 'Number',
										'name' => 'number',
										'type' => 'number',
										'instructions' => 'Please type number for this stat',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'min' => '',
										'max' => '',
										'step' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
									array(
										'key' => 'field_5759474c27a17',
										'label' => 'Icon',
										'name' => 'icon',
										'type' => 'text',
										'instructions' => 'Here you can type your statistic icon:</br>
1. Please go to <a href="https://rscard.px-lab.com/html/icons.html" target="_blank">https://rscard.px-lab.com/html/icons.html</a></br>
2. Copy the icon you need and paste into "Icon" field',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
									),
									array(
										'key' => 'field_5759498427a18',
										'label' => 'Title',
										'name' => 'title',
										'type' => 'text',
										'instructions' => 'The title field for this stat',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
									array(
										'key' => 'field_575949d927a19',
										'label' => 'Textfield',
										'name' => 'textfield',
										'type' => 'text',
										'instructions' => 'The text field, which will appear under the title field',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
								),
							),
							array(
								'key' => 'field_57594b6c27a1b',
								'label' => 'Section Alignment',
								'name' => 'section_alignment',
								'type' => 'select',
								'instructions' => 'You can manage this section\'s alignment',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'choices' => array(
									'left' => 'Left',
									'center' => 'Center',
									'right' => 'Right',
								),
								'default_value' => array(
									0 => 'left',
								),
								'allow_null' => 0,
								'multiple' => 0,
								'ui' => 0,
								'ajax' => 1,
								'placeholder' => '',
								'disabled' => 0,
								'readonly' => 0,
								'return_format' => 'value',
							),
							array(
								'key' => 'field_57594a2f27a1a',
								'label' => 'Custom Editor',
								'name' => 'custom_editor',
								'type' => 'wysiwyg',
								'instructions' => 'You can put here any custom text.',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => '',
								'tabs' => 'all',
								'toolbar' => 'full',
								'media_upload' => 1,
								'delay' => 0,
							),
							array(
								'key' => 'field_57594dfd853b4',
								'label' => 'Menu Id',
								'name' => 'menu_id',
								'type' => 'text',
								'instructions' => 'Please put here the unique id, which will be used for menu',
								'required' => 1,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'statistics',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
						),
						'min' => '',
						'max' => '',
					),
					array(
						'key' => '575963100a069',
						'name' => 'services_section',
						'label' => 'Services Section',
						'display' => 'block',
						'sub_fields' => array(
							array(
								'key' => 'field_575964bf192ed',
								'label' => 'Section Title',
								'name' => 'section_title',
								'type' => 'text',
								'instructions' => 'Here you can type the section\'s title',
								'required' => '',
								'conditional_logic' => '',
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'Our Services',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
							array(
								'key' => 'field_58205b91a9d79',
								'label' => 'Disable The Background',
								'name' => 'disable_the_background',
								'type' => 'checkbox',
								'instructions' => 'Here you can upload the image, which will override the section\'s background image',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'choices' => array(
									'Disable' => 'Disable',
								),
								'default_value' => array(
								),
								'layout' => 'vertical',
								'toggle' => 0,
								'return_format' => 'value',
								'allow_custom' => 0,
								'save_custom' => 0,
							),
							array(
								'key' => 'field_57596530192f0',
								'label' => 'Services',
								'name' => 'services',
								'type' => 'repeater',
								'instructions' => '',
								'required' => 1,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'collapsed' => '',
								'min' => 0,
								'max' => 0,
								'layout' => 'table',
								'button_label' => 'Add Row',
								'sub_fields' => array(
									array(
										'key' => 'field_57596546192f1',
										'label' => 'Icon',
										'name' => 'icon',
										'type' => 'text',
										'instructions' => 'Here you can type your service icon:</br>
1. Please go to <a href="https://rscard.px-lab.com/html/icons.html" target="_blank">https://rscard.px-lab.com/html/icons.html</a></br>
2. Copy the icon you need and paste into "Icon" field',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
									),
									array(
										'key' => 'field_5759659a192f2',
										'label' => 'Title',
										'name' => 'title',
										'type' => 'text',
										'instructions' => 'Please type the title for the service',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
									array(
										'key' => 'field_575965d5192f3',
										'label' => 'Secondary Title',
										'name' => 'secondary_title',
										'type' => 'text',
										'instructions' => 'This field will appear under the title field',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'prepend' => '',
										'append' => '',
										'maxlength' => '',
										'readonly' => 0,
										'disabled' => 0,
									),
									array(
										'key' => 'field_575965fb192f4',
										'label' => 'Description',
										'name' => 'description',
										'type' => 'textarea',
										'instructions' => 'The description field',
										'required' => 0,
										'conditional_logic' => 0,
										'wrapper' => array(
											'width' => '',
											'class' => '',
											'id' => '',
										),
										'default_value' => '',
										'placeholder' => '',
										'maxlength' => '',
										'rows' => '',
										'new_lines' => 'wpautop',
										'readonly' => 0,
										'disabled' => 0,
									),
								),
							),
							array(
								'key' => 'field_575966dad7878',
								'label' => 'Section Alignment',
								'name' => 'section_alignment',
								'type' => 'select',
								'instructions' => 'You can manage this section\'s alignment',
								'required' => 0,
								'conditional_logic' => 0,
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'choices' => array(
									'left' => 'Left',
									'center' => 'Center',
									'right' => 'Right',
								),
								'default_value' => array(
									0 => 'left',
								),
								'allow_null' => 0,
								'multiple' => 0,
								'ui' => 0,
								'ajax' => 0,
								'placeholder' => '',
								'disabled' => 0,
								'readonly' => 0,
								'return_format' => 'value',
							),
							array(
								'key' => 'field_575964e5192ee',
								'label' => 'Custom Editor',
								'name' => 'custom_editor',
								'type' => 'wysiwyg',
								'instructions' => 'You can put here any custom text.',
								'required' => '',
								'conditional_logic' => '',
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => '',
								'tabs' => 'all',
								'toolbar' => 'full',
								'media_upload' => 1,
								'delay' => 0,
							),
							array(
								'key' => 'field_575964ff192ef',
								'label' => 'Menu Id',
								'name' => 'menu_id',
								'type' => 'text',
								'instructions' => 'Please put here the unique id, which will be used for menu',
								'required' => 1,
								'conditional_logic' => '',
								'wrapper' => array(
									'width' => '',
									'class' => '',
									'id' => '',
								),
								'default_value' => 'services',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'maxlength' => '',
								'readonly' => 0,
								'disabled' => 0,
							),
						),
						'min' => '',
						'max' => '',
					),
				),
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'page_template',
					'operator' => '==',
					'value' => 'page-home.php',
				),
			),
		),
		'menu_order' => 0,
		'position' => 'normal',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => array(
			0 => 'the_content',
			1 => 'excerpt',
		),
		'active' => 1,
		'description' => '',
	));

	acf_add_local_field_group(array(
		'key' => 'group_569cccb11148b',
		'title' => 'Page Options',
		'fields' => array(
			array(
				'key' => 'field_569e4395a8323',
				'label' => 'Hide Header Image',
				'name' => 'hide_header_image',
				'type' => 'checkbox',
				'instructions' => 'Select the checkbox if you want to hide header image from this page.',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'choices' => array(
					'Hide' => 'Hide',
				),
				'default_value' => array(
				),
				'layout' => 'vertical',
				'toggle' => 0,
				'allow_custom' => 0,
				'save_custom' => 0,
				'return_format' => 'value',
			),
			array(
				'key' => 'field_569ccf2620165',
				'label' => 'Header Image',
				'name' => 'header_image',
				'type' => 'image',
				'instructions' => 'Please upload header image for this page.',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'return_format' => 'url',
				'preview_size' => 'thumbnail',
				'library' => 'all',
				'min_width' => '',
				'min_height' => '',
				'min_size' => '',
				'max_width' => '',
				'max_height' => '',
				'max_size' => '',
				'mime_types' => '',
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'page',
				),
			),
		),
		'menu_order' => 0,
		'position' => 'normal',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => '',
		'active' => 1,
		'description' => '',
	));

	acf_add_local_field_group(array(
		'key' => 'group_565ed7a84cad4',
		'title' => 'Portfolio Options',
		'fields' => array(
			array(
				'key' => 'field_565ff404974d5',
				'label' => 'Image Size For Grid',
				'name' => 'image_size',
				'type' => 'select',
				'instructions' => 'Please select which image size to be shown on homepage\'s portfolio section',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'choices' => array(
					'Big' => 'Big',
					'Small' => 'Small',
				),
				'default_value' => array(
					0 => 'Small',
				),
				'allow_null' => 0,
				'multiple' => 0,
				'ui' => 0,
				'ajax' => 0,
				'return_format' => 'value',
				'placeholder' => '',
			),
			array(
				'key' => 'field_581c77f07c3f0',
				'label' => 'Logo Image',
				'name' => 'logo_image',
				'type' => 'image',
				'instructions' => 'Please upload the logo image for this portfolio item',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'return_format' => 'array',
				'preview_size' => 'thumbnail',
				'library' => 'all',
				'min_width' => '',
				'min_height' => '',
				'min_size' => '',
				'max_width' => '',
				'max_height' => '',
				'max_size' => '',
				'mime_types' => '',
			),
			array(
				'key' => 'field_565eddacc1fc8',
				'label' => 'Outer Link',
				'name' => 'outer_link',
				'type' => 'text',
				'instructions' => 'You can put the outer link here',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'maxlength' => '',
				'readonly' => 0,
				'disabled' => 0,
			),
			array(
				'key' => 'field_58188ffa89f8a',
				'label' => 'Disable Inner Link',
				'name' => 'disable_inner_link',
				'type' => 'checkbox',
				'instructions' => 'Select the checkbox if you want to disable the inner link to this portfolio item',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'choices' => array(
					'Disable' => 'Disable',
				),
				'default_value' => array(
					0 => 'Disable',
				),
				'layout' => 'vertical',
				'toggle' => 0,
				'return_format' => 'value',
				'allow_custom' => 0,
				'save_custom' => 0,
			),
			array(
				'key' => 'field_5818903b89f8b',
				'label' => 'Disable Popup',
				'name' => 'disable_popup',
				'type' => 'checkbox',
				'instructions' => 'Select the checkbox if you want to disable the popup link on this portfolio item',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'choices' => array(
					'Disable' => 'Disable',
				),
				'default_value' => array(
				),
				'layout' => 'vertical',
				'toggle' => 0,
				'return_format' => 'value',
				'allow_custom' => 0,
				'save_custom' => 0,
			),
			array(
				'key' => 'field_58189b80e1259',
				'label' => 'Project Fields',
				'name' => 'project_fields',
				'type' => 'repeater',
				'instructions' => 'Here you can add the fields for this portfolio item',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'collapsed' => '',
				'min' => 0,
				'max' => 0,
				'layout' => 'table',
				'button_label' => 'Add Row',
				'sub_fields' => array(
					array(
						'key' => 'field_58189bade125a',
						'label' => 'Field Name',
						'name' => 'project_field_name',
						'type' => 'text',
						'instructions' => 'Please type the field name',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'maxlength' => '',
					),
					array(
						'key' => 'field_58189bcfe125b',
						'label' => 'Field Value',
						'name' => 'project_field_value',
						'type' => 'text',
						'instructions' => 'Please type the value for this field',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'maxlength' => '',
					),
				),
			),
			array(
				'key' => 'field_565ed8dc0af3c',
				'label' => 'Popup Content',
				'name' => 'content',
				'type' => 'repeater',
				'instructions' => 'Here you can create your portfolio post\'s popup content',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'collapsed' => '',
				'min' => 0,
				'max' => 0,
				'layout' => 'block',
				'button_label' => 'Add Row',
				'sub_fields' => array(
					array(
						'key' => 'field_565eda4e0af3e',
						'label' => 'Popup Header',
						'name' => 'popup_header',
						'type' => 'select',
						'instructions' => 'Here you can select the header\'s type',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'choices' => array(
							'Image' => 'Image',
							'Video Upload' => 'Video Upload',
							'Video Iframe' => 'Video Iframe',
						),
						'default_value' => array(
						),
						'allow_null' => 1,
						'multiple' => 0,
						'ui' => 0,
						'ajax' => 0,
						'placeholder' => '',
						'disabled' => 0,
						'readonly' => 0,
						'return_format' => 'value',
					),
					array(
						'key' => 'field_565edab30af3f',
						'label' => 'Image',
						'name' => 'image',
						'type' => 'image',
						'instructions' => 'Please upload the image',
						'required' => 0,
						'conditional_logic' => array(
							array(
								array(
									'field' => 'field_565eda4e0af3e',
									'operator' => '==',
									'value' => 'Image',
								),
							),
						),
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'return_format' => 'array',
						'preview_size' => 'thumbnail',
						'library' => 'all',
						'min_width' => '',
						'min_height' => '',
						'min_size' => '',
						'max_width' => '',
						'max_height' => '',
						'max_size' => '',
						'mime_types' => '',
					),
					array(
						'key' => 'field_565edaf30af40',
						'label' => 'Mp4 File',
						'name' => 'mp4_file',
						'type' => 'file',
						'instructions' => 'Please upload the mp4 format video',
						'required' => 0,
						'conditional_logic' => array(
							array(
								array(
									'field' => 'field_565eda4e0af3e',
									'operator' => '==',
									'value' => 'Video Upload',
								),
							),
						),
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'return_format' => 'url',
						'library' => 'all',
						'min_size' => '',
						'max_size' => '',
						'mime_types' => 'mp4',
					),
					array(
						'key' => 'field_565edb2a0af41',
						'label' => 'Webm File',
						'name' => 'webm_file',
						'type' => 'file',
						'instructions' => 'Please upload the webm format video',
						'required' => 0,
						'conditional_logic' => array(
							array(
								array(
									'field' => 'field_565eda4e0af3e',
									'operator' => '==',
									'value' => 'Video Upload',
								),
							),
						),
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'return_format' => 'url',
						'library' => 'all',
						'min_size' => '',
						'max_size' => '',
						'mime_types' => 'webm',
					),
					array(
						'key' => 'field_565edb4f0af42',
						'label' => 'Ogv File',
						'name' => 'ogv_file',
						'type' => 'file',
						'instructions' => 'Please upload the ogv format video',
						'required' => 0,
						'conditional_logic' => array(
							array(
								array(
									'field' => 'field_565eda4e0af3e',
									'operator' => '==',
									'value' => 'Video Upload',
								),
							),
						),
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'return_format' => 'url',
						'library' => 'all',
						'min_size' => '',
						'max_size' => '',
						'mime_types' => 'ogv',
					),
					array(
						'key' => 'field_565edb7a0af43',
						'label' => 'Video Poster',
						'name' => 'video_poster',
						'type' => 'image',
						'instructions' => 'Please upload the poster image for video',
						'required' => 0,
						'conditional_logic' => array(
							array(
								array(
									'field' => 'field_565eda4e0af3e',
									'operator' => '==',
									'value' => 'Video Upload',
								),
							),
						),
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'return_format' => 'url',
						'preview_size' => 'thumbnail',
						'library' => 'all',
						'min_width' => '',
						'min_height' => '',
						'min_size' => '',
						'max_width' => '',
						'max_height' => '',
						'max_size' => '',
						'mime_types' => '',
					),
					array(
						'key' => 'field_565edbb60af44',
						'label' => 'Iframe Url',
						'name' => 'iframe_url',
						'type' => 'text',
						'instructions' => 'Please paste Vimeo , Youtube or dailymotion embedded url here. This option will be working if files above are not uploaded',
						'required' => 0,
						'conditional_logic' => array(
							array(
								array(
									'field' => 'field_565eda4e0af3e',
									'operator' => '==',
									'value' => 'Video Iframe',
								),
							),
						),
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'maxlength' => '',
						'readonly' => 0,
						'disabled' => 0,
					),
					array(
						'key' => 'field_565edbdc0af45',
						'label' => 'Title',
						'name' => 'title',
						'type' => 'text',
						'instructions' => 'Please type the title here',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'maxlength' => '',
						'readonly' => 0,
						'disabled' => 0,
					),
					array(
						'key' => 'field_565edbf10af46',
						'label' => 'Description',
						'name' => 'description',
						'type' => 'wysiwyg',
						'instructions' => 'Please type the description here',
						'required' => 0,
						'conditional_logic' => 0,
						'wrapper' => array(
							'width' => '',
							'class' => '',
							'id' => '',
						),
						'default_value' => '',
						'tabs' => 'all',
						'toolbar' => 'full',
						'media_upload' => 1,
						'delay' => 0,
					),
				),
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'portfolio',
				),
			),
		),
		'menu_order' => 0,
		'position' => 'normal',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => '',
		'active' => 1,
		'description' => '',
	));

	acf_add_local_field_group(array(
		'key' => 'group_569e485bb676b',
		'title' => 'Post Options',
		'fields' => array(
			array(
				'key' => 'field_569e485bc1442',
				'label' => 'Hide Header Image',
				'name' => 'hide_header_image',
				'type' => 'checkbox',
				'instructions' => 'Select the checkbox if you want to hide header image from this post.',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'choices' => array(
					'Hide' => 'Hide',
				),
				'default_value' => array(
				),
				'layout' => 'vertical',
				'toggle' => 0,
				'allow_custom' => 0,
				'save_custom' => 0,
				'return_format' => 'value',
			),
			array(
				'key' => 'field_569e485bc14cc',
				'label' => 'Header Image',
				'name' => 'header_image',
				'type' => 'image',
				'instructions' => 'Please upload header image for this post.',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'return_format' => 'url',
				'preview_size' => 'thumbnail',
				'library' => 'all',
				'min_width' => '',
				'min_height' => '',
				'min_size' => '',
				'max_width' => '',
				'max_height' => '',
				'max_size' => '',
				'mime_types' => '',
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'post',
				),
			),
		),
		'menu_order' => 0,
		'position' => 'normal',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => '',
		'active' => 1,
		'description' => '',
	));

	acf_add_local_field_group(array(
		'key' => 'group_5652e9ab83f5f',
		'title' => 'Standard Post Options',
		'fields' => array(
			array(
				'key' => 'field_5652e9c4599b9',
				'label' => 'Options',
				'name' => '',
				'type' => 'message',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'message' => 'This is the standard post layout. Use featured image option to upload the image for this post',
				'new_lines' => 'wpautop',
				'esc_html' => 0,
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'post_format',
					'operator' => '==',
					'value' => 'standard',
				),
			),
		),
		'menu_order' => 0,
		'position' => 'normal',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => '',
		'active' => 1,
		'description' => '',
	));

	acf_add_local_field_group(array(
		'key' => 'group_5652dfa36dc1d',
		'title' => 'Video Post Options',
		'fields' => array(
			array(
				'key' => 'field_5652e6ff0a08f',
				'label' => 'Mp4 File',
				'name' => 'mp4_file',
				'type' => 'file',
				'instructions' => 'Please upload the mp4 format video',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'return_format' => 'url',
				'library' => 'all',
				'min_size' => '',
				'max_size' => '',
				'mime_types' => 'mp4',
			),
			array(
				'key' => 'field_5652e7600a090',
				'label' => 'Webm File',
				'name' => 'webm_file',
				'type' => 'file',
				'instructions' => 'Please upload the webm format video',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'return_format' => 'url',
				'library' => 'all',
				'min_size' => '',
				'max_size' => '',
				'mime_types' => 'webm',
			),
			array(
				'key' => 'field_5652e7b40a091',
				'label' => 'Ogv File',
				'name' => 'ogv_file',
				'type' => 'file',
				'instructions' => 'Please upload the ogv format video',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'return_format' => 'url',
				'library' => 'all',
				'min_size' => '',
				'max_size' => '',
				'mime_types' => 'ogv',
			),
			array(
				'key' => 'field_5652f5ecdaece',
				'label' => 'Video Poster',
				'name' => 'video_poster',
				'type' => 'image',
				'instructions' => 'Please upload the poster image for video',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'return_format' => 'array',
				'preview_size' => 'thumbnail',
				'library' => 'all',
				'min_width' => '',
				'min_height' => '',
				'min_size' => '',
				'max_width' => '',
				'max_height' => '',
				'max_size' => '',
				'mime_types' => '',
			),
			array(
				'key' => 'field_5652e7d10a092',
				'label' => 'Iframe Url',
				'name' => 'vimeo_youtube_url',
				'type' => 'text',
				'instructions' => 'Please paste Vimeo , Youtube or dailymotion embedded url here. This option will be working if files above are not uploaded',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'maxlength' => '',
				'readonly' => 0,
				'disabled' => 0,
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'post_format',
					'operator' => '==',
					'value' => 'video',
				),
			),
		),
		'menu_order' => 0,
		'position' => 'normal',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => '',
		'active' => 1,
		'description' => '',
	));

endif;