<?php
/**
 * Single Product Meta
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/meta.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.0.3
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $post, $product;

$cat = get_the_terms( $post->ID, 'product_cat' );
$cat_count = is_array($cat) ? sizeof($cat) : 0;
$tags = get_the_terms( $post->ID, 'product_tag' );
$tag_count = is_array($tags) ? sizeof($tags) : 0;

?>
<div class="product_meta">

	<?php do_action( 'woocommerce_product_meta_start' ); ?>

	<?php if ( wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type( 'variable' ) ) ) : ?>

		<div class="sku_wrapper"><strong><?php _e( 'SKU:', 'woocommerce' ); ?></strong><span class="sku" itemprop="sku"><?php echo ( $sku = $product->get_sku() ) ? $sku : __( 'N/A', 'woocommerce' ); ?></span></div>

	<?php endif; ?>

	<?php echo wc_get_product_category_list( $product->get_id(),', ', '<div class="posted_in">' . _n( 'Category:', '<strong>Categories:</strong>', $cat_count, 'woocommerce' ) . ' ', '</div>' ); ?>

	<?php echo wc_get_product_tag_list( $product->get_id(),', ', '<div class="tagged_as">' . _n( 'Tag:', '<strong>Tags:</strong>', $tag_count, 'woocommerce' ) . ' ', '</div>' ); ?>

	<?php do_action( 'woocommerce_product_meta_end' ); ?>

</div>
