<?php
/**
 * Rs-Card functions and definitions
 *
 * Set up the theme and provides some helper functions, which are used in the
 * theme as custom template tags. Others are attached to action and filter
 * hooks in WordPress to change core functionality.
 *
 * When using a child theme you can override certain functions (those wrapped
 * in a function_exists() call) by defining them first in your child theme's
 * functions.php file. The child theme's functions.php file is included before
 * the parent theme's file, so the child theme functions would be used.
 *
 * @link http://codex.wordpress.org/Theme_Development
 * @link http://codex.wordpress.org/Child_Themes
 *
 * Functions that are not pluggable (not wrapped in function_exists()) are
 * instead attached to a filter or action hook.
 *
 * For more information on hooks, actions, and filters,
 * @link http://codex.wordpress.org/Plugin_API
 *
 * @package WordPress
 * @subpackage Rs-Card
 * @since Rs-Card 1.0
 */

/*remove revisions from pages*/
add_action( 'admin_init', 'disable_revisions' );
function disable_revisions() {
	remove_post_type_support( 'page', 'revisions' );
}

/*
 * Add Woocommerce Support
 */

add_action( 'after_setup_theme', 'woocommerce_support' );
function woocommerce_support() {
	add_theme_support( 'woocommerce' );
}

// Remove Woocommerce Styles
add_filter( 'woocommerce_enqueue_styles', 'jk_dequeue_styles' );
function jk_dequeue_styles( $enqueue_styles ) {
	unset( $enqueue_styles['woocommerce-layout'] ); // Remove the layout
	unset( $enqueue_styles['woocommerce-smallscreen'] ); // Remove the smallscreen optimisation
	unset( $enqueue_styles['woocommerce-general'] ); // Remove the gloss

	return $enqueue_styles;
}

// Enqueue Woocommerce Custom Styles 
function wp_enqueue_woocommerce_style() {
	wp_register_style( 'rscard-woocommerce-layout', get_template_directory_uri() . '/woocommerce/css/woocommerce-layout.css' );
	wp_register_style( 'rscard-woocommerce', get_template_directory_uri() . '/woocommerce/css/woocommerce.css' );
	wp_register_style( 'rscard-woocommerce-smallscreen', get_template_directory_uri() . '/woocommerce/css/woocommerce-smallscreen.css' );


	if ( class_exists( 'woocommerce' ) ) {
		wp_enqueue_style( 'rscard-woocommerce' );
		wp_enqueue_style( 'rscard-woocommerce-layout' );
		wp_enqueue_style( 'rscard-woocommerce-smallscreen' );
	}
}

add_action( 'wp_enqueue_scripts', 'wp_enqueue_woocommerce_style' );

/*
 * add to cart
 */
if ( class_exists( 'woocommerce' ) ) {
	add_filter( 'woocommerce_add_to_cart_fragments', 'woocommerce_header_add_to_cart_fragment' );

	function woocommerce_header_add_to_cart_fragment( $fragments ) {
		global $woocommerce;
		ob_start(); ?>

        <a class="head-woo" href="<?php echo esc_url( wc_get_cart_url() ); ?>">
            <i class="rsicon rsicon-shopping-basket"></i>
            <span class="head-woo-count"><?php echo sprintf( _n( '%d', '%d', WC()->cart->cart_contents_count, 'rs-card' ), WC()->cart->cart_contents_count ); ?></span>
        </a>

		<?php
		$fragments['a.head-woo'] = ob_get_clean();

		return $fragments;
	}

	add_theme_support( 'wc-product-gallery-zoom' );
	add_theme_support( 'wc-product-gallery-lightbox' );
	add_theme_support( 'wc-product-gallery-slider' );
}
/*
 * Excerpt More
 */
add_filter( 'excerpt_more', 'rs_card_new_excerpt_more' );

if ( ! isset( $content_width ) ) {
	$content_width = 474;
}

/*
 * Add Required plugins functionality.
 */
require_once get_template_directory() . '/inc/class-tgm-plugin-activation.php';
if ( ! defined( 'rs-card' ) ) {
	define( 'rs-card', 'rs-card' );
}

add_action( 'tgmpa_register', 'rs_card_register_required_plugins' );
function rs_card_register_required_plugins() {
	$plugins = array(
		array(
			'name'               => 'Advanced Custom Fields Pro',
			// The plugin name
			'slug'               => 'advanced-custom-fields-pro',
			// The plugin slug (typically the folder name)
			'source'             => get_template_directory_uri() . '/inc/plugins/advanced-custom-fields-pro.zip',
			// The plugin source
			'version'            => '5.7.9',
			// E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'required'           => true,
			// If false, the plugin is only 'recommended' instead of required
			'force_activation'   => false,
			// If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' => false,
			// If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url'       => '',
			// If set, overrides default API URL and points to an external URL
		),
		array(
			'name'               => 'Portfolio Posts',
			// The plugin name
			'slug'               => 'portfolio-custom-post-type',
			// The plugin slug (typically the folder name)
			'source'             => get_template_directory_uri() . '/inc/plugins/portfolio-custom-post-type.zip',
			// The plugin source
			'version'            => '',
			// E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'required'           => true,
			// If false, the plugin is only 'recommended' instead of required
			'force_activation'   => false,
			// If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' => false,
			// If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url'       => '',
			// If set, overrides default API URL and points to an external URL
		),
		array(
			'name'               => 'Shortcodes',
			// The plugin name
			'slug'               => 'rs-card-shortcodes',
			// The plugin slug (typically the folder name)
			'source'             => get_template_directory_uri() . '/inc/plugins/rs-card-shortcodes.zip',
			// The plugin source
			'version'            => '',
			// E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'required'           => true,
			// If false, the plugin is only 'recommended' instead of required
			'force_activation'   => false,
			// If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' => false,
			// If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url'       => '',
			// If set, overrides default API URL and points to an external URL
		),
		array(
			'name'               => 'Redux Framework',
			// The plugin name
			'slug'               => 'redux-framework',
			// The plugin slug (typically the folder name)
			'source'             => 'https://wordpress.org/plugins/redux-framework/',
			// The plugin source
			'version'            => '',
			// E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'required'           => true,
			// If false, the plugin is only 'recommended' instead of required
			'force_activation'   => false,
			// If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' => false,
			// If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url'       => 'https://wordpress.org/plugins/redux-framework/',
			// If set, overrides default API URL and points to an external URL
		),
		array(
			'name'               => 'Contact Form',
			// The plugin name
			'slug'               => 'rs-card-contact-form',
			// The plugin slug (typically the folder name)
			'source'             => get_template_directory_uri() . '/inc/plugins/rs-card-contact-form.zip',
			// The plugin source
			'version'            => '1.2',
			// E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'required'           => true,
			// If false, the plugin is only 'recommended' instead of required
			'force_activation'   => false,
			// If true, p                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              